var Colors = new Object();
Colors.Normal = CreateColor(255, 255, 255);
Colors.White = CreateColor(255, 255, 255);
Colors.WhiteS = CreateColor(255, 255, 255, 128);
Colors.Blue = CreateColor(0, 150, 240);
Colors.Yellow = CreateColor(253, 176, 23);
Colors.YellowS = CreateColor(253, 176, 23, 128);
Colors.YellowS2 = CreateColor(253, 176, 23, 0);
Colors.Rust = CreateColor(128, 128, 106);
Colors.Grayed = CreateColor(184, 184, 184);
Colors.Red = CreateColor(200, 0, 0);
Colors.Cyan = CreateColor(0, 160, 198);
Colors.CyanS = CreateColor(0, 160, 198, 128);
Colors.Shadow = CreateColor(0, 0, 0, 128);
Colors.Shadow2 = CreateColor(0, 0, 0, 64);
Colors.Empty = CreateColor(0, 0, 0, 0);
Colors.WShadow = CreateColor(255, 255, 255, 128);
Colors.Black = CreateColor(0, 0, 0);
Colors.Gray = CreateColor(128, 128, 128);
Colors.Green = CreateColor(18, 150, 38);

var Images = new Object();

function WindowFunctions()
{
	this.fborder = LoadWindowStyle("Full-Border.rws");
	this.tborder = LoadWindowStyle("Top-Border.rws");
	this.nborder = LoadWindowStyle("No-Border.rws");
	this.heading = LoadWindowStyle("Heading.rws");
}

WindowFunctions.prototype.drawWindow = function(x, y, w, h, border, heading, normal)
{
	var yp = 8;
	if (border == undefined || border == true)
	{
		this.fborder.drawWindow(x, y, w, h);
		yp = 12;
	}
	if (border == false)
	{
		this.nborder.drawWindow(x, y, w, h);
	}
	if (border == "Top")
	{
		this.tborder.drawWindow(x - 4, y - 4, w + 8, h + 8);
		yp = 12;
	}
	if (heading != undefined)
	{
		if (normal == "Away")
		{
			font.littleText(x, y-yp, heading, true);
		}
		else
			font.littleText(x, y-yp, heading);
	}
}

WindowFunctions.prototype.battleWindow = function(x, y, character)
{
	var tcharacter = Game.party[character];
	if (tcharacter.hp > tcharacter.maxhp * 0.25)
	{
		font.battleText(x, y, tcharacter.name);
		font.battleText(x + 87, y, tcharacter.hp, "right");
	}
	if (tcharacter.hp <= tcharacter.maxhp * 0.25 && tcharacter.hp > 0)
	{
		font.battleText(x, y, tcharacter.name, "left", Colors.Yellow);
		font.battleText(x + 87, y, tcharacter.hp, "right", Colors.Yellow);
	}
	if (tcharacter.hp == 0)
	{
		font.battleText(x, y, tcharacter.name, "left", Colors.Red);
		font.battleText(x + 87, y, tcharacter.hp, "right", Colors.Red);
	}
	if (tcharacter.mp > tcharacter.maxmp * 0.25)
	{
		font.battleText(x + 113, y, tcharacter.mp, "right");
	}
	if (tcharacter.mp <= tcharacter.maxmp * 0.25 && tcharacter.mp > 0)
	{
		font.battleText(x + 113, y, tcharacter.mp, "right", Colors.Yellow);
	}
	if (tcharacter.mp == 0)
	{
		font.battleText(x + 113, y, tcharacter.mp, "right", Colors.Red);
	}
	Gauge(x+116, y + 1, 44, tcharacter.time, 1000, Colors.Green, Colors.Blue, true);
}

WindowFunctions.prototype.partyWindow = function(x, y, character, full)
{
	if (full == undefined)
	{
		;
	}
	else
	{
		window.drawWindow(x, y, 194, 44, false);
		window.drawWindow(x + 120, y, 74, 16, false);
		if (character != undefined)
		{
			Rectangle(x + 4, y, 48, 44, Colors.Shadow);
			if (character.position == "Front")
			{
				character.face.blit(x + 4, y);
			}
			else
				character.face.blit(x + 20, y);
			font.drawText(x + 56, y + 2, character.name);
			font.littleText(x + 56, y + 14, "LV");
			font.drawText(x + 87, y + 14, character.lv, "right");
			font.littleText(x + 56, y + 24, "HP");
			font.drawText(x + 101, y + 24, character.hp, "right");
			font.drawText(x + 101, y + 24, "/" + character.maxhp);
			font.littleText(x + 56, y + 34, "MP");
			font.drawText(x + 101, y + 34, character.mp, "right");
			font.drawText(x + 101, y + 34, "/" + character.maxmp);
		}
		else
		{
			font.drawText(x + 8, y + 18, "EMPTY");
			Rectangle(x - 2, y - 2, 198, 48, Colors.Shadow);
		}
	}
}

WindowFunctions.prototype.victoryWindow = function(x, y, character)
{
	window.drawWindow(x, y, 150, 44, false);
	if (character != undefined)
	{
		character.face.blit(x + 1, y + 1);
		font.littleText(x + 120, y + 2, "Lv");
		font.drawText(x + 148, y + 2, character.lv, "right");
		font.drawText(x + 35, y + 23, "EXP");
		font.drawText(x + 148, y + 23, character.exp, "right");
		font.drawText(x + 35, y + 33, "Next");
		font.littleText(x + 62, y + 33, "Lv");
		font.drawText(x + 148, y + 33, character.next, "right");
		if (character.hp > character.maxhp * 0.25)
		{
			font.drawText(x + 35, y + 2, character.name);
		}
		if (character.hp <= character.maxhp * 0.25 && character.hp > 0)
		{
			font.drawText(x + 35, y + 2, character.name, "left", Colors.Yellow);
		}
		if (character.hp == 0)
		{
			font.drawText(x + 35, y + 2, character.name, "left", Colors.Red);
			Rectangle(x - 2, y - 2, 154, 48, Colors.Shadow);
		}
	}
	else
		font.drawText(x + 8, y + 18, "EMPTY");
}

WindowFunctions.prototype.message = function(x, y, w, speaker, text, time, map)
{
	if (Game.messageopen == false && LastPush())
	{
		if (map != undefined)
		{
			Game.personTalking = GetCurrentPerson();
			DetachInput();
			BindKey(Game.accept, "MessageAccept()", "");
		}
		Game.messageopen = true;
		Game.messagex = x;
		Game.messagey = y;
		Game.messagew = w;
		Game.messagetext = text;
		if (speaker != "")
		{
			Game.fulltext = speaker + "\n\"" + text + "\"";
		}
		else
			Game.fulltext = "\"" + text + "\"";
		Game.messageletter = 0;
		if (time == 0)
			Game.messagetime = false;
		else
			Game.messagetime = GetTime() + time;
	}
}

WindowFunctions.prototype.drawMessage = function()
{
	var hp = 1;
	if (Game.fulltext != "\"" + Game.messagetext + "\"")
	{
		hp = 2;
	}
	window.drawWindow(Game.messagex, Game.messagey, Game.messagew, Math.floor(font.font.getStringWidth(Game.fulltext.substr(0, Game.messageletter)) / Game.messagew + hp) * 11 - 1);
	font.drawTextBox(Game.messagex, Game.messagey, Game.messagew, Math.floor(font.font.getStringWidth(Game.fulltext) / Game.messagew + hp) * 11 - 1, Game.fulltext.substr(0, Game.messageletter));
	if (Game.messageletter < Game.fulltext.length)
		Game.messageletter++;
	if (Game.messageletter > Game.fulltext.length)
		Game.messageletter = Game.fulltext.length;
	if (Game.messagetime != false)
	{
		if (GetTime() >= Game.messagetime)
			Game.messageopen = false;
	}
	if (Game.messagetime == false && Game.messageletter >= Game.fulltext.length)
	{
		var tx = Game.messagex + Game.messagew - 5;
		var ty = Game.messagey + Math.floor(font.font.getStringWidth(Game.fulltext) / Game.messagew + hp) * 9;
		Triangle(tx, ty, tx+7, ty, tx+4, ty+8, Colors.Red); // Replace with icon or something
	}
}

function Message(x, y, w, speaker, text, time, map)
{
	if (Game.messageopen == false)
	{
		Game.messageopen = true;
		Game.messagex = x;
		Game.messagey = y;
		Game.messagew = w;
		Game.messagetext = text;
		if (speaker != "")
		{
			Game.fulltext = speaker + "\n\"" + text + "\"";
		}
		else
			Game.fulltext = "\"" + text + "\"";
		Game.messageletter = 0;
		if (time == 0)
			Game.messagetime = false;
		else
			Game.messagetime = GetTime() + time;
		if (map != undefined)
		{
			var background = GrabImage(0, 0, 320, 240);
		}
		while (Game.messageopen == true)
		{
			Interrupt();
			if (map == undefined)
			{
				RenderMap();
			}
			else
				background.blit(0, 0);
			window.drawMessage();
			FlipScreen();
			if (LastPush())
			{
				if (IsKeyPressed(Game.accept))
				{
					if (Game.messagetime == false)
					{
						if (Game.messageletter >= Game.fulltext.length)
						{
							Game.messageopen = false;
							KeyPressed();
						}
					}
				}
			}
		}
	}
}

var window = new WindowFunctions();

function FontFunctions()
{
	this.font = LoadFont("Main.rfn");
	this.title = LoadFont("Title.rfn");
	this.heading = LoadFont("Little.rfn");
	this.battle = LoadFont("Battle.rfn");
	this.battleText = function(x, y, text, alignment, color)
	{
		if (color == undefined)
			color = Colors.Normal;
		if (alignment == undefined)
			alignment = "left";
		var xplus = 0;
		if (alignment == "center")
			xplus = Math.floor(this.battle.getStringWidth(text) / 2);
		if (alignment == "right")
			xplus = this.battle.getStringWidth(text);
		this.battle.setColorMask(color);
		this.battle.drawText(x - xplus, y, text);
	}
	this.drawText = function(x, y, text, alignment, color)
	{
		if (color == undefined)
			color = Colors.Normal;
		if (alignment == undefined)
			alignment = "left";
		var xplus = 0;
		if (alignment == "center")
			xplus = Math.floor(this.font.getStringWidth(text) / 2);
		if (alignment == "right")
			xplus = this.font.getStringWidth(text);
		this.font.setColorMask(color);
		this.font.drawText(x - xplus, y, text);
	}
	this.drawTextBox = function(x, y, w, h, text)
	{
		this.font.setColorMask(Colors.Normal);
		this.font.drawTextBox(x, y, w, h, 0, text);
	}
	this.littleText = function(x, y, text, dim)
	{
		var xp = 0;
		if (dim == undefined)
			this.heading.setColorMask(Colors.Normal);
		else
			this.heading.setColorMask(Colors.Grayed);
		for (var i = 0; i < text.length; i ++)
		{
			this.heading.drawText(x + xp, y, text.substr(i, 1));
			xp += this.heading.getStringWidth(text.substr(i, 1)) - 1;
		}
	}
	this.iconText = function(x, y, obj, color)
	{
		if (color == undefined)
		{
			color = Colors.Normal;
		}
		if (obj != Items.Blank)
		{
			obj.icon.blitMask(x, y, color);
			font.drawText(x + obj.icon.width + 2, y + 2, obj.name);
		}
	}
}

var font = new FontFunctions();

function MapScript()
{
	Interrupt();
	if (Game.menuopen == true && Game.currentmenu != undefined)
	{
		Game.currentmenu.execute(Game.currentmenu.x, Game.currentmenu.y, Game.currentmenu.w, Game.currentmenu.h);
	}
	if (Game.messageopen == true)
	{
		window.drawMessage();
	}
	if (Game.area == true)
	{
		font.drawText(159 - (font.font.getStringWidth(Game.areatext) / 2), 100, Game.areatext);
		var person = GetInputPerson();
		if (GetPersonX(person) < Game.areax - 16 || GetPersonX(person) > Game.areax + 16 || GetPersonY(person) < Game.areay - 16 || GetPersonY(person) > Game.areay + 16)
		{
			Game.area = false;
			Game.areatext = "";
			Game.areamap = "";
		}
	}
}

function ShowArea(text, amap)
{
	Game.area = true;
	Game.areatext = text;
	Game.areax = GetPersonX(GetInputPerson());
	Game.areay = GetPersonY(GetInputPerson());
	Game.areamap = amap;
}

function MessageDone()
{
	if (Game.messageletter >= Game.fulltext.length)
	{
		return false;
	}
	else
		return true;
}

function MessageAccept()
{
	if (Game.messagetime == false && LastPush())
	{
		if (Game.messageletter >= Game.fulltext.length)
		{
			Game.messageopen = false;
			Game.personTalking = undefined;
			Game.last_push = GetTime();
			UnbindKey(Game.accept);
		}
	}
}

function DrawCursor(x, y, transparent)
{
	if (transparent == undefined)
	{
		Images.Selector.blit(x - Images.Selector.width - 2, y - 1);
	}
	else
		Images.Selector.blitMask(x - Images.Selector.width - 2, y - 1, Colors.WhiteS);
}

function Gauge(x, y, l, var1, var2, clr1, clr2)
{
	var glength = Math.floor(var1 * l / var2);
	Rectangle(x, y, l + 2, 7, Colors.Gray);
	Line(x, y, x+l+1, y, Colors.WShadow);
	Line(x, y+1, x, y+6, Colors.WShadow);
	Line(x+1, y+6, x+l+1, y+6, Colors.Shadow);
	Line(x+l+1, y+1, x+l+1, y+5, Colors.Shadow);
	Line(x + 1, y + 7, x + l + 2, y + 7, Colors.Shadow);
	Line(x + l + 2, y + 6, x + l + 2, y + 1, Colors.Shadow);
	if (glength > 0)
	{
		GradientRectangle(x + 1, y + 1, glength, 2, clr1, clr2, BlendColors(clr2, Colors.White), BlendColors(clr1, Colors.White));
		GradientRectangle(x + 1, y + 3, glength, 3, BlendColors(clr1, Colors.White), BlendColors(clr2, Colors.White), clr2, clr1);
	}
	if (glength == l)
	{
		GradientRectangle(x + 1, y + 1, glength, 2, BlendColors(clr1, Colors.White), BlendColors(clr1, Colors.White), BlendColors(clr2, Colors.White), BlendColors(clr2, Colors.White));
		GradientRectangle(x + 1, y + 3, glength, 3, BlendColors(clr2, Colors.White), BlendColors(clr2, Colors.White), BlendColors(clr1, Colors.White), BlendColors(clr1, Colors.White));
	}
}